/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.mennomax.astikorcarts.AstikorCarts;
import de.mennomax.astikorcarts.client.renderer.entity.DrawnRenderer;
import de.mennomax.astikorcarts.client.renderer.entity.model.SupplyCartModel;
import de.mennomax.astikorcarts.entity.SupplyCartEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.PaintingSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.PaintingType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.registries.ForgeRegistries;

public final class SupplyCartRenderer
extends DrawnRenderer<SupplyCartEntity, SupplyCartModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("astikorcarts", "textures/entity/supply_cart.png");
    private final BipedModel<LivingEntity> leggings = new BipedModel(0.5f);
    private final BipedModel<LivingEntity> armor = new BipedModel(1.0f);

    public SupplyCartRenderer(EntityRendererManager renderManager) {
        super(renderManager, new SupplyCartModel());
        this.field_76989_e = 1.0f;
    }

    @Override
    protected void renderContents(SupplyCartEntity entity, float delta, MatrixStack stack, IRenderTypeBuffer source, int packedLight) {
        ItemStack s;
        super.renderContents(entity, delta, stack, source, packedLight);
        NonNullList<ItemStack> cargo = entity.getCargo();
        Contents contents = Contents.SUPPLIES;
        Iterator it = cargo.iterator();
        block0: while (it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.func_190926_b()) continue;
            for (Contents c : Contents.values()) {
                if (!c.predicate.test(s)) continue;
                contents = c;
                break block0;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (ItemStack)it.next();
            if (s.func_190926_b() || contents.predicate.test(s)) continue;
            contents = Contents.SUPPLIES;
        }
        stack.func_227860_a_();
        ((SupplyCartModel)this.model).getBody().func_228307_a_(stack);
        contents.renderer.render(this, entity, stack, source, packedLight, cargo);
        stack.func_227865_b_();
    }

    private void renderFlowers(SupplyCartEntity entity, MatrixStack stack, IRenderTypeBuffer source, int packedLight, NonNullList<ItemStack> cargo) {
        ((SupplyCartModel)this.model).getFlowerBasket().func_228308_a_(stack, source.getBuffer(((SupplyCartModel)this.model).func_228282_a_(this.getEntityTexture(entity))), packedLight, OverlayTexture.field_229196_a_);
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelRenderer renderer = dispatcher.func_175019_b();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (!(itemStack.func_77973_b() instanceof BlockItem)) continue;
            int ix = i % 2;
            int iz = i / 2;
            BlockState defaultState = ((BlockItem)itemStack.func_77973_b()).func_179223_d().func_176223_P();
            BlockState state = defaultState.func_235901_b_((Property)BlockStateProperties.field_208163_P) ? (BlockState)defaultState.func_206870_a((Property)BlockStateProperties.field_208163_P, (Comparable)DoubleBlockHalf.UPPER) : defaultState;
            IBakedModel model = dispatcher.func_184389_a(state);
            int rgb = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, -0.7, -0.1875);
            stack.func_227862_a_(0.65f, 0.65f, 0.65f);
            stack.func_227861_a_((double)ix, 0.5, (double)iz - 1.0);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            renderer.renderModel(stack.func_227866_c_(), source.getBuffer(RenderType.func_228643_e_()), state, model, r, g, b, packedLight, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
            stack.func_227865_b_();
        }
    }

    private void renderWheel(SupplyCartEntity entity, MatrixStack stack, IRenderTypeBuffer source, int packedLight, NonNullList<ItemStack> cargo) {
        stack.func_227861_a_(1.18, 0.1, -0.15);
        ModelRenderer wheel = ((SupplyCartModel)this.model).getWheel();
        wheel.field_78795_f = 0.9f;
        wheel.field_78808_h = 0.9424779f;
        wheel.func_228308_a_(stack, source.getBuffer(((SupplyCartModel)this.model).func_228282_a_(this.getEntityTexture(entity))), packedLight, OverlayTexture.field_229196_a_);
    }

    private void renderPaintings(SupplyCartEntity entity, MatrixStack stack, IRenderTypeBuffer source, int packedLight, NonNullList<ItemStack> cargo) {
        IVertexBuilder buf = source.getBuffer(RenderType.func_228634_a_((ResourceLocation)Minecraft.func_71410_x().func_213263_ao().func_215286_b().func_229241_m_().func_229223_g_()));
        ObjectList types = (ObjectList)StreamSupport.stream(ForgeRegistries.PAINTING_TYPES.spliterator(), false).filter(t -> t.func_200834_b() == 16 && t.func_200832_c() == 16).collect(Collectors.toCollection(ObjectArrayList::new));
        Random rng = new Random(entity.func_110124_au().getMostSignificantBits() ^ entity.func_110124_au().getLeastSignificantBits());
        ObjectLists.shuffle((ObjectList)types, (Random)rng);
        int count = 0;
        for (ItemStack itemStack : cargo) {
            if (itemStack.func_190926_b()) continue;
            ++count;
        }
        stack.func_227861_a_(0.0, -0.15625, 0.0);
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        int n = 0;
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.func_190926_b()) continue;
            PaintingType t2 = (PaintingType)types.get(i % types.size());
            stack.func_227860_a_();
            stack.func_227861_a_(0.0, ((double)n++ - (double)(count - 1) * 0.5) / (double)count, -0.0625 * (double)i);
            stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(rng.nextFloat() * (float)Math.PI));
            this.renderPainting(t2, stack, buf, packedLight);
            stack.func_227865_b_();
        }
    }

    private void renderSupplies(SupplyCartEntity entity, MatrixStack stack, IRenderTypeBuffer source, int packedLight, NonNullList<ItemStack> cargo) {
        ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            ItemStack itemStack = (ItemStack)cargo.get(i);
            if (itemStack.func_190926_b()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((ItemStack)cargo.get(i + 2)).func_77973_b().func_206844_a((ITag)ItemTags.field_219771_F) || i >= 2 && ((ItemStack)cargo.get(i - 2)).func_77973_b().func_206844_a((ITag)ItemTags.field_219771_F)) continue;
            double x = ((double)ix - 0.5) * 11.0 / 16.0;
            double z = ((double)iz * 11.0 - 9.0) / 16.0;
            IBakedModel model = renderer.func_184393_a(itemStack, entity.field_70170_p, null);
            stack.func_227860_a_();
            if (model.func_177556_c() && itemStack.func_77973_b() != Items.field_203184_eO) {
                stack.func_227861_a_(x, -0.46, z);
                stack.func_227862_a_(0.65f, 0.65f, 0.65f);
                stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                if (itemStack.func_77973_b() == Items.field_185159_cQ) {
                    stack.func_227862_a_(1.2f, 1.2f, 1.2f);
                    stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ix == 0 ? -90.0f : 90.0f));
                    stack.func_227861_a_(0.5, 0.8, -0.05);
                    stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-22.5f));
                } else if (iz < 1 && itemStack.func_77973_b().func_206844_a((ITag)ItemTags.field_219771_F)) {
                    stack.func_227861_a_(0.0, 0.0, 1.0);
                } else if (!model.func_188618_c()) {
                    stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                }
                renderer.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.NONE, false, stack, source, packedLight, OverlayTexture.field_229196_a_, model);
            } else {
                rng.setSeed(32L * (long)i + (long)Objects.hashCode(itemStack.func_77973_b().getRegistryName()));
                stack.func_227861_a_(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                if (ArmorItem.class.equals(itemStack.func_77973_b().getClass()) || DyeableArmorItem.class.equals(itemStack.func_77973_b().getClass())) {
                    this.renderArmor(stack, source, packedLight, itemStack, ix);
                } else {
                    stack.func_227862_a_(0.7f, 0.7f, 0.7f);
                    stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(rng.nextFloat() * (float)Math.PI));
                    stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
                    int copies = Math.min(itemStack.func_190916_E(), (itemStack.func_190916_E() - 1) / 16 + 2);
                    renderer.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, false, stack, source, packedLight, OverlayTexture.field_229196_a_, model);
                    for (int n = 1; n < copies; ++n) {
                        stack.func_227860_a_();
                        stack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(rng.nextFloat() * (float)Math.PI));
                        stack.func_227861_a_((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                        renderer.func_229111_a_(itemStack, ItemCameraTransforms.TransformType.FIXED, false, stack, source, packedLight, OverlayTexture.field_229196_a_, model);
                        stack.func_227865_b_();
                    }
                }
            }
            stack.func_227865_b_();
        }
    }

    private void renderArmor(MatrixStack stack, IRenderTypeBuffer source, int packedLight, ItemStack itemStack, int ix) {
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armor = (ArmorItem)item;
        EquipmentSlotType slot = armor.func_185083_B_();
        BipedModel<LivingEntity> m = slot == EquipmentSlotType.LEGS ? this.leggings : this.armor;
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(ix == 0 ? 1.5707964f : -1.5707964f));
        m.func_178719_a(false);
        m.field_228270_o_ = false;
        m.field_217113_d = false;
        m.field_217114_e = false;
        switch (slot) {
            case HEAD: {
                stack.func_227861_a_(0.0, 0.1, 0.0);
                m.field_78116_c.field_78795_f = 0.2f;
                m.field_178720_f.func_217177_a(m.field_78116_c);
                m.field_78116_c.field_78806_j = true;
                m.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                stack.func_227861_a_(0.0, -0.4, -0.15);
                m.field_178724_i.field_78795_f = -0.15f;
                m.field_178723_h.field_78795_f = -0.15f;
                m.field_78115_e.field_78795_f = 0.9f;
                m.field_78115_e.field_78806_j = true;
                m.field_178723_h.field_78806_j = true;
                m.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                stack.func_227861_a_(0.0, -0.7, -0.15);
                m.field_78115_e.field_78795_f = 0.0f;
                m.field_178721_j.field_78795_f = 1.2f;
                m.field_178722_k.field_78795_f = 1.2f;
                m.field_178721_j.field_78796_g = -0.3f;
                m.field_178722_k.field_78796_g = 0.3f;
                m.field_78115_e.field_78806_j = true;
                m.field_178721_j.field_78806_j = true;
                m.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                stack.func_227861_a_(0.0, -1.15, -0.1);
                m.field_178721_j.field_78795_f = 0.0f;
                m.field_178722_k.field_78795_f = 0.0f;
                m.field_178721_j.field_78796_g = -0.1f;
                m.field_178722_k.field_78796_g = 0.0f;
                m.field_178721_j.field_78806_j = true;
                m.field_178722_k.field_78806_j = true;
            }
        }
        stack.func_227862_a_(0.75f, 0.75f, 0.75f);
        ResourceLocation tex = new ResourceLocation(armor.func_200880_d().func_200897_d());
        IVertexBuilder armorBuf = ItemRenderer.func_239386_a_((IRenderTypeBuffer)source, (RenderType)RenderType.func_239263_a_((ResourceLocation)new ResourceLocation(tex.func_110624_b(), String.format("textures/models/armor/%s_layer_%d.png", tex.func_110623_a(), slot == EquipmentSlotType.LEGS ? 2 : 1))), (boolean)false, (boolean)itemStack.func_77962_s());
        if (armor instanceof IDyeableArmorItem) {
            int rgb = ((IDyeableArmorItem)armor).func_200886_f(itemStack);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            m.func_225598_a_(stack, armorBuf, packedLight, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
            IVertexBuilder overlayBuf = ItemRenderer.func_239386_a_((IRenderTypeBuffer)source, (RenderType)RenderType.func_239263_a_((ResourceLocation)new ResourceLocation(tex.func_110624_b(), String.format("textures/models/armor/%s_layer_%d_overlay.png", tex.func_110623_a(), slot == EquipmentSlotType.LEGS ? 2 : 1))), (boolean)false, (boolean)itemStack.func_77962_s());
            m.func_225598_a_(stack, overlayBuf, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            m.func_225598_a_(stack, armorBuf, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void renderPainting(PaintingType painting, MatrixStack stack, IVertexBuilder buf, int packedLight) {
        PaintingSpriteUploader uploader = Minecraft.func_71410_x().func_213263_ao();
        int width = painting.func_200834_b();
        int height = painting.func_200832_c();
        TextureAtlasSprite art = uploader.func_215285_a(painting);
        TextureAtlasSprite back = uploader.func_215286_b();
        Matrix4f model = stack.func_227866_c_().func_227870_a_();
        Matrix3f normal = stack.func_227866_c_().func_227872_b_();
        int blockWidth = width / 16;
        int blockHeight = height / 16;
        float offsetX = (float)(-blockWidth) / 2.0f;
        float offsetY = (float)(-blockHeight) / 2.0f;
        float depth = 0.03125f;
        float bu0 = back.func_94209_e();
        float bu1 = back.func_94212_f();
        float bv0 = back.func_94206_g();
        float bv1 = back.func_94210_h();
        float bup = back.func_94214_a(1.0);
        float bvp = back.func_94207_b(1.0);
        double uvX = 16.0 / (double)blockWidth;
        double uvY = 16.0 / (double)blockHeight;
        for (int x = 0; x < blockWidth; ++x) {
            for (int y = 0; y < blockHeight; ++y) {
                float x1 = offsetX + (float)(x + 1);
                float x0 = offsetX + (float)x;
                float y1 = offsetY + (float)(y + 1);
                float y0 = offsetY + (float)y;
                float u0 = art.func_94214_a(uvX * (double)(blockWidth - x));
                float u1 = art.func_94214_a(uvX * (double)(blockWidth - x - 1));
                float v0 = art.func_94207_b(uvY * (double)(blockHeight - y));
                float v1 = art.func_94207_b(uvY * (double)(blockHeight - y - 1));
                this.vert(model, normal, buf, x1, y0, u1, v0, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x0, y0, u0, v0, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x0, y1, u0, v1, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x1, y1, u1, v1, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bv0, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bv1, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv1, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bv0, -0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bvp, 0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bvp, 0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv0, 0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bv0, 0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bvp, -0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bvp, -0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bup, bv0, 0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bup, bv1, 0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv1, -0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bup, bv0, -0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bup, bv1, -0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu0, bv1, 0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu0, bv0, 0.03125f, 1, 0, 0, packedLight);
            }
        }
    }

    private void vert(Matrix4f stack, Matrix3f normal, IVertexBuilder buf, float x, float y, float u, float v, float z, int nx, int ny, int nz, int packedLight) {
        buf.func_227888_a_(stack, x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, (float)nx, (float)ny, (float)nz).func_181675_d();
    }

    public ResourceLocation getEntityTexture(SupplyCartEntity entity) {
        return TEXTURE;
    }

    @FunctionalInterface
    private static interface ContentsRenderer {
        public void render(SupplyCartRenderer var1, SupplyCartEntity var2, MatrixStack var3, IRenderTypeBuffer var4, int var5, NonNullList<ItemStack> var6);
    }

    private static enum Contents {
        FLOWERS(s -> s.func_77973_b() instanceof BlockItem && s.func_77973_b().func_206844_a((ITag)ItemTags.field_226159_I_), (rec$, x$0, x$1, x$2, x$3, x$4) -> SupplyCartRenderer.access$500(rec$, x$0, x$1, x$2, x$3, x$4)),
        PAINTINGS(s -> s.func_77973_b() == Items.field_151159_an, (rec$, x$0, x$1, x$2, x$3, x$4) -> SupplyCartRenderer.access$400(rec$, x$0, x$1, x$2, x$3, x$4)),
        WHEEL(s -> AstikorCarts.Items.WHEEL.test(s.func_77973_b()), (rec$, x$0, x$1, x$2, x$3, x$4) -> SupplyCartRenderer.access$300(rec$, x$0, x$1, x$2, x$3, x$4)),
        SUPPLIES(s -> true, (rec$, x$0, x$1, x$2, x$3, x$4) -> SupplyCartRenderer.access$200(rec$, x$0, x$1, x$2, x$3, x$4));

        private final Predicate<? super ItemStack> predicate;
        private final ContentsRenderer renderer;

        private Contents(Predicate<? super ItemStack> predicate, ContentsRenderer renderer) {
            this.predicate = predicate;
            this.renderer = renderer;
        }
    }
}

